/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.p.service.isolate.proc;

import com.ibm.hwmca.fw.service.managedsystem.fru.FruListController;
import com.ibm.hwmca.fw.service.managedsystem.fru.FruListControllerException;
import com.ibm.hwmca.fw.service.panel.GenericGui;
import com.ibm.hwmca.fw.service.serviceaction.ProblemMonitor;
import com.ibm.hwmca.fw.service.statetransition.Context;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.xfw.pa.problem.CommonProblem;
import com.ibm.hwmca.xfw.service.SD;
import com.ibm.hwmca.xfw.service.managedsystem.fru.DefaultFru;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class PIIsolateUtility {
    private static final String TRACE_MASKT = "XRVPPOST";
    private static final String TRACE_MASKF = "XRVPPOSF";
    private static final String TRACE_MASKD = "XRVPPOSD";

    public String getLocationTrunk(String location) {
        int dash = 0;
        dash = location.indexOf(45);
        if (dash != -1) {
            location = location.substring(0, dash);
        }
        return location;
    }

    public void deactivate(Map dataMap, DefaultFru fru, String location) {
        try {
            fru.getProperties().put("LOCATION", location);
            fru.elementLevelDeactivate(dataMap);
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "   elementLevelDeactivate exception caught: " + e);
            Trace.trace(TRACE_MASKF, e);
            System.out.print("********FruException");
            return;
        }
    }

    public void activate(Map dataMap, DefaultFru fru, String location) {
        try {
            fru.getProperties().put("LOCATION", location);
            fru.elementLevelActivate(dataMap);
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "   elementLevelActivate exception caught: " + e);
            Trace.trace(TRACE_MASKF, e);
            System.out.print("********AFruException");
            return;
        }
    }

    public void reorganizeFrulist(Map dataMap, List fruElements) {
        FruListController flc = (FruListController)dataMap.get("FRU_LIST_CONTROLLER");
        try {
            flc.modify(fruElements, 1, dataMap);
        }
        catch (FruListControllerException e) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkRefcode(Map dataMap, String ref) {
        String refcode = null;
        ProblemMonitor pm = (ProblemMonitor)dataMap.get("PROBLEM_MONITOR");
        System.out.print("pm******" + pm);
        pm.clear();
        pm.start();
        try {
            PIIsolateUtility.showBusy(dataMap, new LocalizableText("Please wait for 3 minutes."));
            Thread.sleep(180000L);
        }
        catch (InterruptedException e) {
        }
        finally {
            PIIsolateUtility.destroyBusy(dataMap);
        }
        pm.stop();
        List probs = pm.getDetectedProblems();
        System.out.print("probs******" + probs);
        if (probs != null) {
            Iterator it = probs.iterator();
            while (it.hasNext()) {
                Object[] a = (Object[])it.next();
                CommonProblem cp = (CommonProblem)a[0];
                refcode = cp.getRefcode();
                System.out.print("refcode******" + refcode);
                if (refcode == null || !refcode.equalsIgnoreCase(ref)) continue;
                break;
            }
        }
        if (refcode != null && refcode.equalsIgnoreCase(ref)) {
            System.out.print("returnTrue******");
            return true;
        }
        System.out.print("returnfalse******");
        return false;
    }

    public static void showBusy(Map dataMap, LocalizableText msg) {
        try {
            GenericGui guiHandle = (GenericGui)dataMap.get("DISPLAY_HANDLE");
            guiHandle.showBusyDialog(new LocalizableText("Verification progress"), msg, dataMap);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void destroyBusy(Map dataMap) {
        try {
            GenericGui guiHandle = (GenericGui)dataMap.get("DISPLAY_HANDLE");
            guiHandle.destroyBusyDialog(dataMap);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isDelay(Map dataMap) {
        Context c = (Context)dataMap.get("STS_CONTEXT");
        return c.getVariable(SD.OVERALL_STATUS_VARIABLE).getValue().equals(SD.DELAY);
    }
}

